int[] particles;
boolean[] pixelUpdates;
int[][] chunkState;
int widthChunks, heightChunks;
int chunkSize = 32;
boolean paused = false;
boolean drawChunks = false;
boolean[] pressed = new boolean[3];
int paintSize = 100;
int paintSizeOffset = 64;
int xorshift = 3;
int widthheight;
int element = 1;
float airDensity = 1.239;
float sandDensity = 1500;
float waterDensity = 997;
float[] density = {airDensity, sandDensity, waterDensity};
float airViscosity = 1;
float sandviscosity = 63;
float waterViscosity = 31;
float[] viscosity = {airViscosity, sandviscosity, waterViscosity};

float totalMillisStart, totalMillisTotal, loadPixelsMillisStart, loadPixelsMillisTotal, mouseParticlesMillisStart, mouseParticlesMillisTotal, particlePhysicsMillisStart, particlePhysicsMillisTotal, drawParticlesMillisStart, drawParticlesMillisTotal, updatePixelsMillisStart, updatePixelsMillisTotal, userInterfaceMillisStart, userInterfaceMillisTotal, updateChunksMillisStart, updateChunksMillisTotal;

void setup() {
  fullScreen(JAVA2D);
  frameRate(144);
  noSmooth();
  
  widthheight = width * height;
  
  particles = new int[widthheight];
  pixelUpdates = new boolean[widthheight];
  
  widthChunks = ceil(float(width) / chunkSize);
  heightChunks = ceil(float(height) / chunkSize);
  chunkState = new int[widthChunks][heightChunks];
}

void draw() {
  totalMillisStart = millis();
  
  loadPixelsMillisStart = millis();
  loadPixels();
  loadPixelsMillisTotal = loadPixelsMillisTotal *.99 + (millis() - loadPixelsMillisStart) * .01;
  
  mouseParticlesMillisStart = millis();
  mouseParticles();
  mouseParticlesMillisTotal = mouseParticlesMillisTotal *.99 + (millis() - mouseParticlesMillisStart) * .01;

  particlePhysicsMillisStart = millis();
  particlePhysics();
  particlePhysicsMillisTotal = particlePhysicsMillisTotal *.99 + (millis() - particlePhysicsMillisStart) * .01;
  
  drawParticlesMillisStart = millis();
  drawParticles();
  drawParticlesMillisTotal = drawParticlesMillisTotal *.99 + (millis() - drawParticlesMillisStart) * .01;
  
  updatePixelsMillisStart = millis();
  updatePixels();
  updatePixelsMillisTotal = updatePixelsMillisTotal *.99 + (millis() - updatePixelsMillisStart) * .01;
  
  userInterfaceMillisStart = millis();
  userInterface();
  userInterfaceMillisTotal = userInterfaceMillisTotal *.99 + (millis() - userInterfaceMillisStart) * .01;
  
  updateChunksMillisStart = millis();
  updateChunks();
  updateChunksMillisTotal = updateChunksMillisTotal *.99 + (millis() - updateChunksMillisStart) * .01;
  
  totalMillisTotal = totalMillisTotal *.99 + (millis() - totalMillisStart) * .01;
}
