void particlePhysics() {
  if (!paused) {
    final boolean random = abs(xorshift()) >> 30 == 0;
    int g, h, i, j;
    if (random) {
      for (h = heightChunks - 1; h > -1; h--) for (g = 0; g < widthChunks; g++) if (chunkState[g][h] != 0) {
        int gTimesChunkSize = g * chunkSize;
        int hTimesChunkSize = h * chunkSize;
        for (i = gTimesChunkSize; i < gTimesChunkSize + chunkSize; i++) for (j = hTimesChunkSize + chunkSize - 1; j > hTimesChunkSize - 1; j--) if (j < height && i < width) updateParticles(i, j);
      }
    } else for (h = heightChunks - 1; h > -1; h--) for (g = widthChunks - 1; g > -1; g--) if (chunkState[g][h] != 0) {
      int gTimesChunkSize = g * chunkSize;
      int hTimesChunkSize = h * chunkSize;
      for (i = gTimesChunkSize + chunkSize - 1; i > gTimesChunkSize - 1; i--) for (j = hTimesChunkSize + chunkSize - 1; j > hTimesChunkSize - 1; j--) if (j < height && i < width) updateParticles(i, j);
    }
  }
}

void updateParticles(int i, int j) {
  switch(particles[i + j * width]) {
  case 1:
    updateSand(i, j);
    break;
  case 2:
    updateWater(i, j);
  }
}

void updateSand(int i, int j) {
  int[] options = new int[3];
  int index = 0;

  final int jAdd1MultWidth = (j + 1) * width;
  final int down = i + jAdd1MultWidth;
  final int left = i - 1 + jAdd1MultWidth;
  final int right = i + 1 + jAdd1MultWidth;

  if (inBoundsCheck(i, j + 1) && density[particles[down]] < sandDensity) {
    options[0] = 0;
    index++;
  }
  if (inBoundsCheck(i - 1, j + 1) && density[particles[left]] < sandDensity) {
    options[index] = 1;
    index++;
  }
  if (inBoundsCheck(i + 1, j + 1) && density[particles[right]] < sandDensity) {
    options[index] = 2;
    index++;
  }

  if (index != 0) {
    switch(options[abs(xorshift()) % index]) {
    case 0:
      if (abs(xorshift) >> 25 > viscosity[particles[down]]) {
        particles[i + j * width] = particles[down];
        particles[down] = 1;
        chunkState[i / chunkSize][(j + 1) / chunkSize] = 2;
      }
      break;
    case 1:
      if (abs(xorshift) >> 25 > viscosity[particles[left]]) {
        particles[i + j * width] = particles[left];
        particles[left] = 1;
        chunkState[(i - 1) / chunkSize][(j + 1) / chunkSize] = 2;
      }
      break;
    case 2:
      if (abs(xorshift) >> 25 > viscosity[particles[right]]) {
        particles[i + j * width] = particles[right];
        particles[right] = 1;
        chunkState[(i + 1) / chunkSize][(j + 1) / chunkSize] = 2;
      }
    }
    int iDivChunkSize = i / chunkSize;
    int iModChunkSize = i % chunkSize;
    chunkState[iDivChunkSize][(j - 1) / chunkSize] = 2;
    if (iModChunkSize == 0 && i != 0) chunkState[iDivChunkSize - 1][j / chunkSize] = 2;
    else if (iModChunkSize == chunkSize - 1 && i != width - 1) chunkState[iDivChunkSize + 1][j / chunkSize] = 2;
  }
}

void updateWater(int i, int j) {
  int[] options = new int[5];
  int index = 0;

  final int jAdd1MultWidth = (j + 1) * width;
  final int down = i + jAdd1MultWidth;
  final int leftdown = i - 1 + jAdd1MultWidth;
  final int rightdown = i + 1 + jAdd1MultWidth;
  final int left = i - 1 + j * width;
  final int right = i + 1 + j * width;

  if (inBoundsCheck(i, j + 1) && density[particles[down]] < waterDensity) {
    options[0] = 0;
    index++;
  }
  if (inBoundsCheck(i - 1, j + 1) && density[particles[leftdown]] < waterDensity) {
    options[index] = 1;
    index++;
  }
  if (inBoundsCheck(i + 1, j + 1) && density[particles[rightdown]] < waterDensity) {
    options[index] = 2;
    index++;
  }
  if (inBoundsCheck(i - 1, j) && density[particles[left]] < waterDensity) {
    options[index] = 3;
    index++;
  }
  if (inBoundsCheck(i + 1, j) && density[particles[right]] < waterDensity) {
    options[index] = 4;
    index++;
  }

  if (index != 0) {
    switch(options[abs(xorshift()) % index]) {
    case 0:
      if (abs(xorshift) >> 25 > viscosity[particles[down]]) {
        particles[i + j * width] = particles[down];
        particles[down] = 2;
        chunkState[i / chunkSize][(j + 1) / chunkSize] = 2;
      }
      break;
    case 1:
      if (abs(xorshift) >> 25 > viscosity[particles[leftdown]]) {
        particles[i + j * width] = particles[leftdown];
        particles[leftdown] = 2;
        chunkState[(i - 1) / chunkSize][(j + 1) / chunkSize] = 2;
      }
      break;
    case 2:
      if (abs(xorshift) >> 25 > viscosity[particles[rightdown]]) {
        particles[i + j * width] = particles[rightdown];
        particles[rightdown] = 2;
        chunkState[(i + 1) / chunkSize][(j + 1) / chunkSize] = 2;
      }
      break;
    case 3:
      if (abs(xorshift) >> 25 > viscosity[particles[left]]) {
        particles[i + j * width] = particles[left];
        particles[left] = 2;
        chunkState[(i - 1) / chunkSize][j / chunkSize] = 2;
      }
      break;
    case 4:
      if (abs(xorshift) >> 25 > viscosity[particles[right]]) {
        particles[i + j * width] = particles[right];
        particles[right] = 2;
        chunkState[(i + 1) / chunkSize][j / chunkSize] = 2;
      }
    }
    int iDivChunkSize = i / chunkSize;
    int iModChunkSize = i % chunkSize;
    chunkState[iDivChunkSize][(j - 1) / chunkSize] = 2;
    if (iModChunkSize == 0 && i != 0) chunkState[iDivChunkSize - 1][j / chunkSize] = 2;
    else if (iModChunkSize == chunkSize - 1 && i != width - 1) chunkState[iDivChunkSize + 1][j / chunkSize] = 2;
  }
}
