void mouseParticles() {
  if (mousePressed) for (int i = 0; i < width; i++) for (int j = 0; j < height; j++) {
    float distance = sq(i - mouseX) + sq(j - mouseY);
    if (distance < paintSize) {
      if (mouseButton == LEFT && particles[i + j * width] == 0) {
        particles[i + j * width] = element;
        chunkState[i / chunkSize][j /chunkSize] = 1;
      } else if (mouseButton == RIGHT && particles[i + j * width] != 0) {
        particles[i + j * width] = 0;
        chunkState[i / chunkSize][j /chunkSize] = 1;
      }
    }
  }
  if (keyPressed) {
    if (!pressed[0] && key == ' ') {
      paused = !paused;
      pressed[0] = true;
    }
    if (!pressed[1] && key == 'c') {
      drawChunks = !drawChunks;
      pressed[1] = true;
    }
    if (!pressed[2] && key == 'e') {
      element++;
      if (element > 2) element = 1;
      pressed[2] = true;
    }
  }
}

void keyReleased() {
  if (key == ' ') pressed[0] = false;
  if (key == 'c') pressed[1] = false;
  if (key == 'e') pressed[2] = false;
}

void mouseWheel(MouseEvent event) {
  if (abs(event.getCount()) == event.getCount()) paintSize = (int)sq(sqrt(paintSize) - 10);
  else paintSize = (int)sq(sqrt(paintSize) + 10);
  if (paintSize < 100) paintSize = 100;
  paintSizeOffset = (int)sq(sqrt(paintSize) - 2);
}
