/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.event.MouseEvent;

public class sandbox
extends PApplet {
    int[] particles;
    boolean[] pixelUpdates;
    int[][] chunkState;
    int widthChunks;
    int heightChunks;
    int chunkSize = 32;
    boolean paused = false;
    boolean drawChunks = false;
    boolean[] pressed = new boolean[3];
    int paintSize = 100;
    int paintSizeOffset = 64;
    int xorshift = 3;
    int widthheight;
    int element = 1;
    float airDensity = 1.239f;
    float sandDensity = 1500.0f;
    float waterDensity = 997.0f;
    float[] density = new float[]{this.airDensity, this.sandDensity, this.waterDensity};
    float airViscosity = 1.0f;
    float sandviscosity = 63.0f;
    float waterViscosity = 31.0f;
    float[] viscosity = new float[]{this.airViscosity, this.sandviscosity, this.waterViscosity};
    float totalMillisStart;
    float totalMillisTotal;
    float loadPixelsMillisStart;
    float loadPixelsMillisTotal;
    float mouseParticlesMillisStart;
    float mouseParticlesMillisTotal;
    float particlePhysicsMillisStart;
    float particlePhysicsMillisTotal;
    float drawParticlesMillisStart;
    float drawParticlesMillisTotal;
    float updatePixelsMillisStart;
    float updatePixelsMillisTotal;
    float userInterfaceMillisStart;
    float userInterfaceMillisTotal;
    float updateChunksMillisStart;
    float updateChunksMillisTotal;

    public void setup() {
        this.frameRate(144.0f);
        this.widthheight = this.width * this.height;
        this.particles = new int[this.widthheight];
        this.pixelUpdates = new boolean[this.widthheight];
        this.widthChunks = sandbox.ceil((float)(PApplet.parseFloat((int)this.width) / (float)this.chunkSize));
        this.heightChunks = sandbox.ceil((float)(PApplet.parseFloat((int)this.height) / (float)this.chunkSize));
        this.chunkState = new int[this.widthChunks][this.heightChunks];
    }

    public void draw() {
        this.totalMillisStart = this.millis();
        this.loadPixelsMillisStart = this.millis();
        this.loadPixels();
        this.loadPixelsMillisTotal = this.loadPixelsMillisTotal * 0.99f + ((float)this.millis() - this.loadPixelsMillisStart) * 0.01f;
        this.mouseParticlesMillisStart = this.millis();
        this.mouseParticles();
        this.mouseParticlesMillisTotal = this.mouseParticlesMillisTotal * 0.99f + ((float)this.millis() - this.mouseParticlesMillisStart) * 0.01f;
        this.particlePhysicsMillisStart = this.millis();
        this.particlePhysics();
        this.particlePhysicsMillisTotal = this.particlePhysicsMillisTotal * 0.99f + ((float)this.millis() - this.particlePhysicsMillisStart) * 0.01f;
        this.drawParticlesMillisStart = this.millis();
        this.drawParticles();
        this.drawParticlesMillisTotal = this.drawParticlesMillisTotal * 0.99f + ((float)this.millis() - this.drawParticlesMillisStart) * 0.01f;
        this.updatePixelsMillisStart = this.millis();
        this.updatePixels();
        this.updatePixelsMillisTotal = this.updatePixelsMillisTotal * 0.99f + ((float)this.millis() - this.updatePixelsMillisStart) * 0.01f;
        this.userInterfaceMillisStart = this.millis();
        this.userInterface();
        this.userInterfaceMillisTotal = this.userInterfaceMillisTotal * 0.99f + ((float)this.millis() - this.userInterfaceMillisStart) * 0.01f;
        this.updateChunksMillisStart = this.millis();
        this.updateChunks();
        this.updateChunksMillisTotal = this.updateChunksMillisTotal * 0.99f + ((float)this.millis() - this.updateChunksMillisStart) * 0.01f;
        this.totalMillisTotal = this.totalMillisTotal * 0.99f + ((float)this.millis() - this.totalMillisStart) * 0.01f;
    }

    public void drawParticles() {
        int i = 0;
        while (i < this.widthheight) {
            float distance;
            switch (this.particles[i]) {
                case 0: {
                    this.pixels[i] = -16777216;
                    break;
                }
                case 1: {
                    this.pixels[i] = -4017536;
                    break;
                }
                case 2: {
                    this.pixels[i] = -2821639;
                }
            }
            if (this.pixelUpdates[i]) {
                this.pixels[i] = -65536;
            }
            if ((distance = sandbox.sq((float)(i % this.width - this.mouseX)) + sandbox.sq((float)(i / this.width - this.mouseY))) < (float)this.paintSize && distance > (float)this.paintSizeOffset) {
                this.pixels[i] = -1;
            }
            ++i;
        }
    }

    public boolean inBoundsCheck(int i, int j) {
        return i >= 0 && j >= 0 && i < this.width && j < this.height;
    }

    public void mouseParticles() {
        if (this.mousePressed) {
            int i = 0;
            while (i < this.width) {
                int j = 0;
                while (j < this.height) {
                    float distance = sandbox.sq((float)(i - this.mouseX)) + sandbox.sq((float)(j - this.mouseY));
                    if (distance < (float)this.paintSize) {
                        if (this.mouseButton == 37 && this.particles[i + j * this.width] == 0) {
                            this.particles[i + j * this.width] = this.element;
                            this.chunkState[i / this.chunkSize][j / this.chunkSize] = 1;
                        } else if (this.mouseButton == 39 && this.particles[i + j * this.width] != 0) {
                            this.particles[i + j * this.width] = 0;
                            this.chunkState[i / this.chunkSize][j / this.chunkSize] = 1;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.keyPressed) {
            if (!this.pressed[0] && this.key == ' ') {
                this.paused = !this.paused;
                this.pressed[0] = true;
            }
            if (!this.pressed[1] && this.key == 'c') {
                this.drawChunks = !this.drawChunks;
                this.pressed[1] = true;
            }
            if (!this.pressed[2] && this.key == 'e') {
                ++this.element;
                if (this.element > 2) {
                    this.element = 1;
                }
                this.pressed[2] = true;
            }
        }
    }

    public void keyReleased() {
        if (this.key == ' ') {
            this.pressed[0] = false;
        }
        if (this.key == 'c') {
            this.pressed[1] = false;
        }
        if (this.key == 'e') {
            this.pressed[2] = false;
        }
    }

    public void mouseWheel(MouseEvent event) {
        this.paintSize = sandbox.abs((int)event.getCount()) == event.getCount() ? (int)sandbox.sq((float)(sandbox.sqrt((float)this.paintSize) - 10.0f)) : (int)sandbox.sq((float)(sandbox.sqrt((float)this.paintSize) + 10.0f));
        if (this.paintSize < 100) {
            this.paintSize = 100;
        }
        this.paintSizeOffset = (int)sandbox.sq((float)(sandbox.sqrt((float)this.paintSize) - 2.0f));
    }

    public void particlePhysics() {
        block14: {
            boolean random;
            if (this.paused) break block14;
            boolean bl = random = sandbox.abs((int)this.xorshift()) >> 30 == 0;
            if (random) {
                int h = this.heightChunks - 1;
                while (h > -1) {
                    int g = 0;
                    while (g < this.widthChunks) {
                        if (this.chunkState[g][h] != 0) {
                            int gTimesChunkSize = g * this.chunkSize;
                            int hTimesChunkSize = h * this.chunkSize;
                            int i = gTimesChunkSize;
                            while (i < gTimesChunkSize + this.chunkSize) {
                                int j = hTimesChunkSize + this.chunkSize - 1;
                                while (j > hTimesChunkSize - 1) {
                                    if (j < this.height && i < this.width) {
                                        this.updateParticles(i, j);
                                    }
                                    --j;
                                }
                                ++i;
                            }
                        }
                        ++g;
                    }
                    --h;
                }
            } else {
                int h = this.heightChunks - 1;
                while (h > -1) {
                    int g = this.widthChunks - 1;
                    while (g > -1) {
                        if (this.chunkState[g][h] != 0) {
                            int gTimesChunkSize = g * this.chunkSize;
                            int hTimesChunkSize = h * this.chunkSize;
                            int i = gTimesChunkSize + this.chunkSize - 1;
                            while (i > gTimesChunkSize - 1) {
                                int j = hTimesChunkSize + this.chunkSize - 1;
                                while (j > hTimesChunkSize - 1) {
                                    if (j < this.height && i < this.width) {
                                        this.updateParticles(i, j);
                                    }
                                    --j;
                                }
                                --i;
                            }
                        }
                        --g;
                    }
                    --h;
                }
            }
        }
    }

    public void updateParticles(int i, int j) {
        switch (this.particles[i + j * this.width]) {
            case 1: {
                this.updateSand(i, j);
                break;
            }
            case 2: {
                this.updateWater(i, j);
            }
        }
    }

    public void updateSand(int i, int j) {
        int[] options = new int[3];
        int index = 0;
        int jAdd1MultWidth = (j + 1) * this.width;
        int down = i + jAdd1MultWidth;
        int left = i - 1 + jAdd1MultWidth;
        int right = i + 1 + jAdd1MultWidth;
        if (this.inBoundsCheck(i, j + 1) && this.density[this.particles[down]] < this.sandDensity) {
            options[0] = 0;
            ++index;
        }
        if (this.inBoundsCheck(i - 1, j + 1) && this.density[this.particles[left]] < this.sandDensity) {
            options[index] = 1;
            ++index;
        }
        if (this.inBoundsCheck(i + 1, j + 1) && this.density[this.particles[right]] < this.sandDensity) {
            options[index] = 2;
            ++index;
        }
        if (index != 0) {
            switch (options[sandbox.abs((int)this.xorshift()) % index]) {
                case 0: {
                    if (!((float)(sandbox.abs((int)this.xorshift) >> 25) > this.viscosity[this.particles[down]])) break;
                    this.particles[i + j * this.width] = this.particles[down];
                    this.particles[down] = 1;
                    this.chunkState[i / this.chunkSize][(j + 1) / this.chunkSize] = 2;
                    break;
                }
                case 1: {
                    if (!((float)(sandbox.abs((int)this.xorshift) >> 25) > this.viscosity[this.particles[left]])) break;
                    this.particles[i + j * this.width] = this.particles[left];
                    this.particles[left] = 1;
                    this.chunkState[(i - 1) / this.chunkSize][(j + 1) / this.chunkSize] = 2;
                    break;
                }
                case 2: {
                    if (!((float)(sandbox.abs((int)this.xorshift) >> 25) > this.viscosity[this.particles[right]])) break;
                    this.particles[i + j * this.width] = this.particles[right];
                    this.particles[right] = 1;
                    this.chunkState[(i + 1) / this.chunkSize][(j + 1) / this.chunkSize] = 2;
                }
            }
            int iDivChunkSize = i / this.chunkSize;
            int iModChunkSize = i % this.chunkSize;
            this.chunkState[iDivChunkSize][(j - 1) / this.chunkSize] = 2;
            if (iModChunkSize == 0 && i != 0) {
                this.chunkState[iDivChunkSize - 1][j / this.chunkSize] = 2;
            } else if (iModChunkSize == this.chunkSize - 1 && i != this.width - 1) {
                this.chunkState[iDivChunkSize + 1][j / this.chunkSize] = 2;
            }
        }
    }

    public void updateWater(int i, int j) {
        int[] options = new int[5];
        int index = 0;
        int jAdd1MultWidth = (j + 1) * this.width;
        int down = i + jAdd1MultWidth;
        int leftdown = i - 1 + jAdd1MultWidth;
        int rightdown = i + 1 + jAdd1MultWidth;
        int left = i - 1 + j * this.width;
        int right = i + 1 + j * this.width;
        if (this.inBoundsCheck(i, j + 1) && this.density[this.particles[down]] < this.waterDensity) {
            options[0] = 0;
            ++index;
        }
        if (this.inBoundsCheck(i - 1, j + 1) && this.density[this.particles[leftdown]] < this.waterDensity) {
            options[index] = 1;
            ++index;
        }
        if (this.inBoundsCheck(i + 1, j + 1) && this.density[this.particles[rightdown]] < this.waterDensity) {
            options[index] = 2;
            ++index;
        }
        if (this.inBoundsCheck(i - 1, j) && this.density[this.particles[left]] < this.waterDensity) {
            options[index] = 3;
            ++index;
        }
        if (this.inBoundsCheck(i + 1, j) && this.density[this.particles[right]] < this.waterDensity) {
            options[index] = 4;
            ++index;
        }
        if (index != 0) {
            switch (options[sandbox.abs((int)this.xorshift()) % index]) {
                case 0: {
                    if (!((float)(sandbox.abs((int)this.xorshift) >> 25) > this.viscosity[this.particles[down]])) break;
                    this.particles[i + j * this.width] = this.particles[down];
                    this.particles[down] = 2;
                    this.chunkState[i / this.chunkSize][(j + 1) / this.chunkSize] = 2;
                    break;
                }
                case 1: {
                    if (!((float)(sandbox.abs((int)this.xorshift) >> 25) > this.viscosity[this.particles[leftdown]])) break;
                    this.particles[i + j * this.width] = this.particles[leftdown];
                    this.particles[leftdown] = 2;
                    this.chunkState[(i - 1) / this.chunkSize][(j + 1) / this.chunkSize] = 2;
                    break;
                }
                case 2: {
                    if (!((float)(sandbox.abs((int)this.xorshift) >> 25) > this.viscosity[this.particles[rightdown]])) break;
                    this.particles[i + j * this.width] = this.particles[rightdown];
                    this.particles[rightdown] = 2;
                    this.chunkState[(i + 1) / this.chunkSize][(j + 1) / this.chunkSize] = 2;
                    break;
                }
                case 3: {
                    if (!((float)(sandbox.abs((int)this.xorshift) >> 25) > this.viscosity[this.particles[left]])) break;
                    this.particles[i + j * this.width] = this.particles[left];
                    this.particles[left] = 2;
                    this.chunkState[(i - 1) / this.chunkSize][j / this.chunkSize] = 2;
                    break;
                }
                case 4: {
                    if (!((float)(sandbox.abs((int)this.xorshift) >> 25) > this.viscosity[this.particles[right]])) break;
                    this.particles[i + j * this.width] = this.particles[right];
                    this.particles[right] = 2;
                    this.chunkState[(i + 1) / this.chunkSize][j / this.chunkSize] = 2;
                }
            }
            int iDivChunkSize = i / this.chunkSize;
            int iModChunkSize = i % this.chunkSize;
            this.chunkState[iDivChunkSize][(j - 1) / this.chunkSize] = 2;
            if (iModChunkSize == 0 && i != 0) {
                this.chunkState[iDivChunkSize - 1][j / this.chunkSize] = 2;
            } else if (iModChunkSize == this.chunkSize - 1 && i != this.width - 1) {
                this.chunkState[iDivChunkSize + 1][j / this.chunkSize] = 2;
            }
        }
    }

    public void updateChunks() {
        if (!this.paused) {
            int i = 0;
            while (i < this.widthChunks) {
                int j = 0;
                while (j < this.heightChunks) {
                    if (this.chunkState[i][j] != 0) {
                        int[] nArray = this.chunkState[i];
                        int n = j;
                        nArray[n] = nArray[n] - 1;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void userInterface() {
        if (this.drawChunks) {
            int i = 0;
            while (i < this.widthChunks) {
                int j = 0;
                while (j < this.heightChunks) {
                    if (this.chunkState[i][j] == 2) {
                        this.stroke(0.0f, 255.0f, 0.0f);
                    } else if (this.chunkState[i][j] == 1) {
                        this.stroke(255.0f, 0.0f, 255.0f);
                    }
                    if (this.chunkState[i][j] != 0) {
                        this.noFill();
                        this.rect(i * this.chunkSize, j * this.chunkSize, this.chunkSize - 1, this.chunkSize - 1);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.fill(0.0f, 255.0f, 255.0f);
        if (this.paused) {
            this.text("PAUSED", this.width - 60, this.height - 20);
        }
        this.text(this.frameRate, 20.0f, this.height - 20);
        this.text(this.totalMillisTotal, 120.0f, this.height - 20);
        this.text(this.loadPixelsMillisTotal, 220.0f, this.height - 20);
        this.text(this.mouseParticlesMillisTotal, 320.0f, this.height - 20);
        this.text(this.particlePhysicsMillisTotal, 420.0f, this.height - 20);
        this.text(this.drawParticlesMillisTotal, 520.0f, this.height - 20);
        this.text(this.updatePixelsMillisTotal, 620.0f, this.height - 20);
        this.text(this.userInterfaceMillisTotal, 720.0f, this.height - 20);
        this.text(this.updateChunksMillisTotal, 820.0f, this.height - 20);
        this.text("frameRate", 20.0f, this.height - 40);
        this.text("total", 120.0f, this.height - 40);
        this.text("loadPixels", 220.0f, this.height - 40);
        this.text("mouseParticles", 320.0f, this.height - 40);
        this.text("particlePhysics", 420.0f, this.height - 40);
        this.text("drawParticles", 520.0f, this.height - 40);
        this.text("updatePixels", 620.0f, this.height - 40);
        this.text("userInterface", 720.0f, this.height - 40);
        this.text("updateChunks", 820.0f, this.height - 40);
    }

    public int xorshift() {
        this.xorshift ^= this.xorshift << 13;
        this.xorshift ^= this.xorshift >> 17;
        this.xorshift ^= this.xorshift << 5;
        return this.xorshift;
    }

    public void settings() {
        this.fullScreen("processing.awt.PGraphicsJava2D");
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "sandbox"};
        if (passedArgs != null) {
            PApplet.main((String[])sandbox.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

