void updateVectors()
{
  int mouseXGrid = (mouseX + cellWidth / 2) / cellWidth;
  int mouseYGrid = (mouseY + cellHeight / 2) / cellHeight;

  vectors[mouseXGrid][mouseYGrid] = new PVector(mouseX - (mouseXGrid) * cellWidth, mouseY - (mouseYGrid) * cellHeight).normalize();

  if (mouseXGrid != columns && mouseYGrid != rows) chunkState[mouseXGrid][mouseYGrid] = true;
  if (mouseXGrid != 0 && mouseYGrid != rows) chunkState[mouseXGrid - 1][mouseYGrid] = true;
  if (mouseYGrid != 0 && mouseXGrid != columns) chunkState[mouseXGrid][mouseYGrid - 1] = true;
  if (mouseXGrid != 0 && mouseYGrid != 0)chunkState[mouseXGrid - 1][mouseYGrid - 1] = true;
}

void keyPressed()
{
  if (key == ' ')
  {
    theme++;
    if (theme > 17) theme = 0;

    activateAllChunks();

    switch(theme)
    {
    case 0:
      fill(0xFF00FFFF);
      stroke(0xFF00FFFF);
      break;
    case 1:
      fill(0xFF000000);
      stroke(0xFF000000);
      break;
    case 4:
      fill(0xFFFF00FF);
      stroke(0xFFFF00FF);
      break;
    case 5:
      fill(0xFF000000);
      stroke(0xFF000000);
      break;
    case 8:
      fill(0xFFFF00FF);
      stroke(0xFFFF00FF);
      break;
    case 9:
      fill(0xFFFFFFFF);
      stroke(0xFFFFFFFF);
      break;
    case 15:
      fill(0xFFFF00FF);
      stroke(0xFFFF00FF);
    }
  }
}
