final int columns = 16;
final int rows = 9;
int cellWidth, cellHeight;

boolean[][] chunkState = new boolean[columns][rows];

float horizontalPixelFactor, verticalPixelFactor;

int iMax, jMax;

PVector[][] vectors = new PVector[columns + 1][rows + 1];

int theme = 0;

void setup()
{
  fullScreen(JAVA2D);
  frameRate(1000);
  noSmooth();
  fill(0xFF00FFFF);
  stroke(0xFF00FFFF);

  cellWidth = width / columns;
  cellHeight = height / rows;

  iMax = columns * cellWidth;
  jMax = rows * cellHeight;

  horizontalPixelFactor = 1.0 / cellWidth;
  verticalPixelFactor = 1.0 / cellHeight;

  for (int i = 0; i <= columns; i++) for (int j = 0; j <= rows; j++) vectors[i][j] = PVector.random2D();

  activateAllChunks();

  loadPixels();
}

void draw()
{
  if (mousePressed) updateVectors();

  drawNoise();

  updateChunks();

  //drawGrid();

  drawVectors();

  text(frameRate, 20, height - 20);
}
