void drawNoise()
{
  float horizontalOffset = 0;
  for (int i = 0; i < cellWidth; i++)
  {
    float verticalOffset = 0;
    for (int j = 0; j < cellHeight; j++)
    {
      final float smoothstepFactorX = smoothstep(horizontalOffset);
      final float smoothstepFactorY = smoothstep(verticalOffset);

      final PVector offsetTopLeft = new PVector(horizontalOffset, verticalOffset);
      final PVector offsetTopRight = new PVector(horizontalOffset - 1, verticalOffset);
      final PVector offsetBottomLeft = new PVector(horizontalOffset, verticalOffset - 1);
      final PVector offsetBottomRight = new PVector(horizontalOffset - 1, verticalOffset - 1);

      int horizontalPosition = i;
      for (int currentColumn = 0; currentColumn < columns; currentColumn++)
      {
        int verticalPosition = j;
        for (int currentRow = 0; currentRow < rows; currentRow++)
        {
          if (chunkState[currentColumn][currentRow])
          {
            final float dotTopLeft = dotProduct(vectors[currentColumn][currentRow], offsetTopLeft);
            final float dotTopRight = dotProduct(vectors[currentColumn + 1][currentRow], offsetTopRight);
            final float dotBottomLeft = dotProduct(vectors[currentColumn][currentRow + 1], offsetBottomLeft);
            final float dotBottomRight = dotProduct(vectors[currentColumn + 1][currentRow + 1], offsetBottomRight);

            final float value = (dotBottomRight * smoothstepFactorX + dotBottomLeft * (1 - smoothstepFactorX)) * smoothstepFactorY + (dotTopRight * smoothstepFactorX + dotTopLeft * (1 - smoothstepFactorX)) * (1 - smoothstepFactorY);

            pixels[horizontalPosition + verticalPosition * width] = colorize(value);
          }
          verticalPosition += cellHeight;
        }
        horizontalPosition += cellWidth;
      }
      verticalOffset += verticalPixelFactor;
    }
    horizontalOffset += horizontalPixelFactor;
  }
  updatePixels();
}

float dotProduct(PVector a, PVector b)
{
  return a.x * b.x + a.y * b.y;
}

float smoothstep(float x)
{
  return x * x * (3 - 2 * x);
}
