int colorize(float x)
{
  switch(theme)
  {
  case 0:
    return 0xFF << 24 | int((x + 1) * 0x7F) << 16 | int((x + 1) * 0x7F) << 8 | int((x + 1) * 0x7F);
  case 1:
    return 0xFF << 24 | cap((x + 1) * 0xFF) << 16 | cap(0xFF - x * 0xFF) << 8 | cap(0xFF - x * 0xFF);
  case 2:
    return 0xFF << 24 | cap(0xFF - x * 0xFF) << 16 | cap((x + 1) * 0xFF) << 8 | cap(0xFF - x * 0xFF);
  case 3:
    return 0xFF << 24 | cap(0xFF - x * 0xFF) << 16 | cap(0xFF - x * 0xFF) << 8 | cap((x + 1) * 0xFF);
  case 4:
    return x < 0 ? 0xFF000000 : 0xFFFFFFFF;
  case 5:
    return x < 0 ? 0xFFFF0000 : 0xFF00FFFF;
  case 6:
    return x < 0 ? 0xFF00FF00 : 0xFFFF00FF;
  case 7:
    return x < 0 ? 0xFF0000FF : 0xFFFFFF00;
  case 8:
    return x < 0 ? x < -.2 ? 0xFF000000 : 0xFF555555 : x > .2 ? 0xFFFFFFFF : 0xFFAAAAAA;
  case 9:
    return x < 0 ? x < -.2 ? 0xFF000000 : 0xFF551000 : x > .2 ? 0xFFFF0000 : 0xFFAA0800;
  case 10:
    return x < 0 ? x < -.2 ? 0xFF000000 : 0xFF456500 : x > .2 ? 0xFFFFFF00 : 0xFFA2B200;
  case 11:
    return x < 0 ? x < -.2 ? 0xFF000000 : 0xFF005510 : x > .2 ? 0xFF00FF00 : 0xFF00AA08;
  case 12:
    return x < 0 ? x < -.2 ? 0xFF000000 : 0xFF004565 : x > .2 ? 0xFF00FFFF : 0xFF00A2B2;
  case 13:
    return x < 0 ? x < -.2 ? 0xFF000000 : 0xFF100055 : x > .2 ? 0xFF0000FF : 0xFF0800AA;
  case 14:
    return x < 0 ? x < -.2 ? 0xFF000000 : 0xFF650045 : x > .2 ? 0xFFFF00FF : 0xFFB200A2;
  case 15:
    return x > -.1 && x < .1 ? 0xFFFFFFFF : 0xFF000000;
  case 16:
    return 0xFF << 24 | int(abs(x) * 0xFF) << 16 | int(abs(x) * 0xFF) << 8 | int(abs(x) * 0xFF);
  case 17:
    return 0xFF << 24 | 0xFF - int(abs(x) * 0xFF) << 16 | 0xFF - int(abs(x) * 0xFF) << 8 | 0xFF - int(abs(x) * 0xFF);
  }
  return 0;
}

int cap(float x)
{
  if (x > 255) return 255;
  return int(x);
}
