/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PVector;

public class perlin_noise
extends PApplet {
    final int columns = 16;
    final int rows = 9;
    int cellWidth;
    int cellHeight;
    boolean[][] chunkState = new boolean[16][9];
    float horizontalPixelFactor;
    float verticalPixelFactor;
    int iMax;
    int jMax;
    PVector[][] vectors = new PVector[17][10];
    int theme = 0;

    public void setup() {
        this.frameRate(1000.0f);
        this.fill(-16711681);
        this.stroke(-16711681);
        this.cellWidth = this.width / 16;
        this.cellHeight = this.height / 9;
        this.iMax = 16 * this.cellWidth;
        this.jMax = 9 * this.cellHeight;
        this.horizontalPixelFactor = 1.0f / (float)this.cellWidth;
        this.verticalPixelFactor = 1.0f / (float)this.cellHeight;
        int i = 0;
        while (i <= 16) {
            int j = 0;
            while (j <= 9) {
                this.vectors[i][j] = PVector.random2D();
                ++j;
            }
            ++i;
        }
        this.activateAllChunks();
        this.loadPixels();
    }

    public void draw() {
        if (this.mousePressed) {
            this.updateVectors();
        }
        this.drawNoise();
        this.updateChunks();
        this.drawVectors();
        this.text(this.frameRate, 20.0f, this.height - 20);
    }

    public void updateChunks() {
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 9) {
                this.chunkState[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    public void activateAllChunks() {
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 9) {
                this.chunkState[i][j] = true;
                ++j;
            }
            ++i;
        }
    }

    public int colorize(float x) {
        switch (this.theme) {
            case 0: {
                return 0xFF000000 | PApplet.parseInt((float)((x + 1.0f) * 127.0f)) << 16 | PApplet.parseInt((float)((x + 1.0f) * 127.0f)) << 8 | PApplet.parseInt((float)((x + 1.0f) * 127.0f));
            }
            case 1: {
                return 0xFF000000 | this.cap((x + 1.0f) * 255.0f) << 16 | this.cap(255.0f - x * 255.0f) << 8 | this.cap(255.0f - x * 255.0f);
            }
            case 2: {
                return 0xFF000000 | this.cap(255.0f - x * 255.0f) << 16 | this.cap((x + 1.0f) * 255.0f) << 8 | this.cap(255.0f - x * 255.0f);
            }
            case 3: {
                return 0xFF000000 | this.cap(255.0f - x * 255.0f) << 16 | this.cap(255.0f - x * 255.0f) << 8 | this.cap((x + 1.0f) * 255.0f);
            }
            case 4: {
                return x < 0.0f ? -16777216 : -1;
            }
            case 5: {
                return x < 0.0f ? -65536 : -16711681;
            }
            case 6: {
                return x < 0.0f ? -16711936 : -65281;
            }
            case 7: {
                return x < 0.0f ? -16776961 : -256;
            }
            case 8: {
                return x < 0.0f ? (x < -0.2f ? -16777216 : -11184811) : (x > 0.2f ? -1 : -5592406);
            }
            case 9: {
                return x < 0.0f ? (x < -0.2f ? -16777216 : -11202560) : (x > 0.2f ? -65536 : -5634048);
            }
            case 10: {
                return x < 0.0f ? (x < -0.2f ? -16777216 : -12229376) : (x > 0.2f ? -256 : -6114816);
            }
            case 11: {
                return x < 0.0f ? (x < -0.2f ? -16777216 : -16755440) : (x > 0.2f ? -16711936 : -16733688);
            }
            case 12: {
                return x < 0.0f ? (x < -0.2f ? -16777216 : -16759451) : (x > 0.2f ? -16711681 : -16735566);
            }
            case 13: {
                return x < 0.0f ? (x < -0.2f ? -16777216 : -15728555) : (x > 0.2f ? -16776961 : -16252758);
            }
            case 14: {
                return x < 0.0f ? (x < -0.2f ? -16777216 : -10158011) : (x > 0.2f ? -65281 : -5111646);
            }
            case 15: {
                return x > -0.1f && x < 0.1f ? -1 : -16777216;
            }
            case 16: {
                return 0xFF000000 | PApplet.parseInt((float)(perlin_noise.abs((float)x) * 255.0f)) << 16 | PApplet.parseInt((float)(perlin_noise.abs((float)x) * 255.0f)) << 8 | PApplet.parseInt((float)(perlin_noise.abs((float)x) * 255.0f));
            }
            case 17: {
                return 0xFF000000 | 255 - PApplet.parseInt((float)(perlin_noise.abs((float)x) * 255.0f)) << 16 | 255 - PApplet.parseInt((float)(perlin_noise.abs((float)x) * 255.0f)) << 8 | 255 - PApplet.parseInt((float)(perlin_noise.abs((float)x) * 255.0f));
            }
        }
        return 0;
    }

    public int cap(float x) {
        if (x > 255.0f) {
            return 255;
        }
        return PApplet.parseInt((float)x);
    }

    public void drawGrid() {
        int i = 0;
        while (i < 16) {
            this.line(i * this.cellWidth, 0.0f, i * this.cellWidth, this.height);
            ++i;
        }
        i = 0;
        while (i < 9) {
            this.line(0.0f, i * this.cellHeight, this.width, i * this.cellHeight);
            ++i;
        }
    }

    public void drawNoise() {
        float horizontalOffset = 0.0f;
        int i = 0;
        while (i < this.cellWidth) {
            float verticalOffset = 0.0f;
            int j = 0;
            while (j < this.cellHeight) {
                float smoothstepFactorX = this.smoothstep(horizontalOffset);
                float smoothstepFactorY = this.smoothstep(verticalOffset);
                PVector offsetTopLeft = new PVector(horizontalOffset, verticalOffset);
                PVector offsetTopRight = new PVector(horizontalOffset - 1.0f, verticalOffset);
                PVector offsetBottomLeft = new PVector(horizontalOffset, verticalOffset - 1.0f);
                PVector offsetBottomRight = new PVector(horizontalOffset - 1.0f, verticalOffset - 1.0f);
                int horizontalPosition = i;
                int currentColumn = 0;
                while (currentColumn < 16) {
                    int verticalPosition = j;
                    int currentRow = 0;
                    while (currentRow < 9) {
                        if (this.chunkState[currentColumn][currentRow]) {
                            float dotTopLeft = this.dotProduct(this.vectors[currentColumn][currentRow], offsetTopLeft);
                            float dotTopRight = this.dotProduct(this.vectors[currentColumn + 1][currentRow], offsetTopRight);
                            float dotBottomLeft = this.dotProduct(this.vectors[currentColumn][currentRow + 1], offsetBottomLeft);
                            float dotBottomRight = this.dotProduct(this.vectors[currentColumn + 1][currentRow + 1], offsetBottomRight);
                            float value = (dotBottomRight * smoothstepFactorX + dotBottomLeft * (1.0f - smoothstepFactorX)) * smoothstepFactorY + (dotTopRight * smoothstepFactorX + dotTopLeft * (1.0f - smoothstepFactorX)) * (1.0f - smoothstepFactorY);
                            this.pixels[horizontalPosition + verticalPosition * this.width] = this.colorize(value);
                        }
                        verticalPosition += this.cellHeight;
                        ++currentRow;
                    }
                    horizontalPosition += this.cellWidth;
                    ++currentColumn;
                }
                verticalOffset += this.verticalPixelFactor;
                ++j;
            }
            horizontalOffset += this.horizontalPixelFactor;
            ++i;
        }
        this.updatePixels();
    }

    public float dotProduct(PVector a, PVector b) {
        return a.x * b.x + a.y * b.y;
    }

    public float smoothstep(float x) {
        return x * x * (3.0f - 2.0f * x);
    }

    public void drawVectors() {
        int i = 0;
        while (i <= 16) {
            int j = 0;
            while (j <= 9) {
                this.line(i * this.cellWidth, j * this.cellHeight, (float)(i * this.cellWidth) + this.vectors[i][j].x * 30.0f, (float)(j * this.cellHeight) + this.vectors[i][j].y * 30.0f);
                ++j;
            }
            ++i;
        }
    }

    public void updateVectors() {
        int mouseXGrid = (this.mouseX + this.cellWidth / 2) / this.cellWidth;
        int mouseYGrid = (this.mouseY + this.cellHeight / 2) / this.cellHeight;
        this.vectors[mouseXGrid][mouseYGrid] = new PVector((float)(this.mouseX - mouseXGrid * this.cellWidth), (float)(this.mouseY - mouseYGrid * this.cellHeight)).normalize();
        if (mouseXGrid != 16 && mouseYGrid != 9) {
            this.chunkState[mouseXGrid][mouseYGrid] = true;
        }
        if (mouseXGrid != 0 && mouseYGrid != 9) {
            this.chunkState[mouseXGrid - 1][mouseYGrid] = true;
        }
        if (mouseYGrid != 0 && mouseXGrid != 16) {
            this.chunkState[mouseXGrid][mouseYGrid - 1] = true;
        }
        if (mouseXGrid != 0 && mouseYGrid != 0) {
            this.chunkState[mouseXGrid - 1][mouseYGrid - 1] = true;
        }
    }

    public void keyPressed() {
        if (this.key == ' ') {
            ++this.theme;
            if (this.theme > 17) {
                this.theme = 0;
            }
            this.activateAllChunks();
            switch (this.theme) {
                case 0: {
                    this.fill(-16711681);
                    this.stroke(-16711681);
                    break;
                }
                case 1: {
                    this.fill(-16777216);
                    this.stroke(-16777216);
                    break;
                }
                case 4: {
                    this.fill(-65281);
                    this.stroke(-65281);
                    break;
                }
                case 5: {
                    this.fill(-16777216);
                    this.stroke(-16777216);
                    break;
                }
                case 8: {
                    this.fill(-65281);
                    this.stroke(-65281);
                    break;
                }
                case 9: {
                    this.fill(-1);
                    this.stroke(-1);
                    break;
                }
                case 15: {
                    this.fill(-65281);
                    this.stroke(-65281);
                }
            }
        }
    }

    public void settings() {
        this.fullScreen("processing.awt.PGraphicsJava2D");
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "perlin_noise"};
        if (passedArgs != null) {
            PApplet.main((String[])perlin_noise.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

