/* autogenerated by Processing revision 1293 on 2024-04-28 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class mandelbrot_set extends PApplet {

int it = 64;
int s;
double xp, yp = 0;
double z = 1;
int res = 1;

public void setup() {
  /* size commented out by preprocessor */;
  colorMode(HSB, 100);
  s = width < height ? width : height;
}

public void draw() {
  if (mousePressed) {
    xp += pmouseX - mouseX;
    yp += pmouseY - mouseY;
  }
  loadPixels();
  for (double x = 0; x < width; x += res)
    for (double y = 0; y < height; y += res) {
      int n = -1;
      for (double cr = (x + xp - width / 2) / s * 4 * z, ci = (y + yp - height / 2) / s * 4 * z, zr = 0, zi = 0, b = 0; n < it && zr * zr + zi * zi <= 4; n++, b = zr * zr - zi * zi + cr, zi = zr * zi * 2 + ci, zr = b) {}
      for (int i = 0; i < res; i++)
        for (int j = 0; j < res; j++) {
          if ((int)(x + i + (y + j) * width) < pixels.length)
            pixels[(int)(x + i + (y + j) * width)] = n < it ? color(n % 100, 100, 100) : color(0);
        }
    }
  updatePixels();
}

public void mouseWheel(MouseEvent e) {
  z = abs(e.getCount()) / e.getCount() == 1 ? z * 1.1f : z / 1.1f;
  xp = abs(e.getCount()) / e.getCount() == 1 ? (xp - (mouseX - width / 2) / 10.98f) / 1.1f : (xp + (mouseX - width / 2) / 10.98f) * 1.1f;
  yp = abs(e.getCount()) / e.getCount() == 1 ? (yp - (mouseY - height / 2) / 10.98f) / 1.1f : (yp + (mouseY - height / 2) / 10.98f) * 1.1f;
}

public void keyPressed() {
  if (key == 'i') it *= 2;
  if (key == 'o') it /= 2;
  if (key == 'x') {
    z *= 1.1f;
    xp = (xp - (mouseX - width / 2) / 10.98f) / 1.1f;
    yp = (yp - (mouseY - height / 2) / 10.98f) / 1.1f;
  }
  if (key == 'z') {
    z /= 1.1f;
    xp = (xp + (mouseX - width / 2) / 10.98f) * 1.1f;
    yp = (yp + (mouseY - height / 2) / 10.98f) * 1.1f;
  }
  if (key == 'a' && res > 1) res -= 1;
  if (key == 's') res += 1;
}


  public void settings() { fullScreen(); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "mandelbrot_set" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
