/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.event.MouseEvent;

public class mandelbrot_set
extends PApplet {
    int it = 64;
    int s;
    double xp;
    double yp = 0.0;
    double z = 1.0;
    int res = 1;

    public void setup() {
        this.colorMode(3, 100.0f);
        this.s = this.width < this.height ? this.width : this.height;
    }

    public void draw() {
        if (this.mousePressed) {
            this.xp += (double)(this.pmouseX - this.mouseX);
            this.yp += (double)(this.pmouseY - this.mouseY);
        }
        this.loadPixels();
        double x = 0.0;
        while (x < (double)this.width) {
            double y = 0.0;
            while (y < (double)this.height) {
                int n = -1;
                double cr = (x + this.xp - (double)(this.width / 2)) / (double)this.s * 4.0 * this.z;
                double ci = (y + this.yp - (double)(this.height / 2)) / (double)this.s * 4.0 * this.z;
                double zr = 0.0;
                double zi = 0.0;
                double b = 0.0;
                while (n < this.it && zr * zr + zi * zi <= 4.0) {
                    ++n;
                    b = zr * zr - zi * zi + cr;
                    zi = zr * zi * 2.0 + ci;
                    zr = b;
                }
                int i = 0;
                while (i < this.res) {
                    int j = 0;
                    while (j < this.res) {
                        if ((int)(x + (double)i + (y + (double)j) * (double)this.width) < this.pixels.length) {
                            this.pixels[(int)(x + (double)i + (y + (double)j) * (double)this.width)] = n < this.it ? this.color(n % 100, 100, 100) : this.color(0);
                        }
                        ++j;
                    }
                    ++i;
                }
                y += (double)this.res;
            }
            x += (double)this.res;
        }
        this.updatePixels();
    }

    public void mouseWheel(MouseEvent e) {
        this.z = mandelbrot_set.abs((int)e.getCount()) / e.getCount() == 1 ? this.z * (double)1.1f : this.z / (double)1.1f;
        this.xp = mandelbrot_set.abs((int)e.getCount()) / e.getCount() == 1 ? (this.xp - (double)((float)(this.mouseX - this.width / 2) / 10.98f)) / (double)1.1f : (this.xp + (double)((float)(this.mouseX - this.width / 2) / 10.98f)) * (double)1.1f;
        this.yp = mandelbrot_set.abs((int)e.getCount()) / e.getCount() == 1 ? (this.yp - (double)((float)(this.mouseY - this.height / 2) / 10.98f)) / (double)1.1f : (this.yp + (double)((float)(this.mouseY - this.height / 2) / 10.98f)) * (double)1.1f;
    }

    public void keyPressed() {
        if (this.key == 'i') {
            this.it *= 2;
        }
        if (this.key == 'o') {
            this.it /= 2;
        }
        if (this.key == 'x') {
            this.z *= (double)1.1f;
            this.xp = (this.xp - (double)((float)(this.mouseX - this.width / 2) / 10.98f)) / (double)1.1f;
            this.yp = (this.yp - (double)((float)(this.mouseY - this.height / 2) / 10.98f)) / (double)1.1f;
        }
        if (this.key == 'z') {
            this.z /= (double)1.1f;
            this.xp = (this.xp + (double)((float)(this.mouseX - this.width / 2) / 10.98f)) * (double)1.1f;
            this.yp = (this.yp + (double)((float)(this.mouseY - this.height / 2) / 10.98f)) * (double)1.1f;
        }
        if (this.key == 'a' && this.res > 1) {
            --this.res;
        }
        if (this.key == 's') {
            ++this.res;
        }
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "mandelbrot_set"};
        if (passedArgs != null) {
            PApplet.main((String[])mandelbrot_set.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

