/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;

public class game_of_life
extends PApplet {
    boolean[][] curr;
    boolean[][] next;
    float c = 0.0f;
    int time = 0;
    int g = 2;
    int w;
    int h;

    public void setup() {
        this.noCursor();
        this.colorMode(3, 100.0f);
        this.w = this.width / this.g + 2;
        this.h = this.height / this.g + 2;
        this.curr = new boolean[this.w][this.h];
        this.next = new boolean[this.w][this.h];
        this.rand();
        this.render();
    }

    public void draw() {
        this.periodicBoundary();
        this.generate();
        this.convert();
        this.render();
        this.time();
    }

    public void keyPressed() {
        if (this.key == ' ') {
            this.rand();
            this.render();
        }
    }

    public void convert() {
        int i = 1;
        while (i < this.w - 1) {
            int j = 1;
            while (j < this.h - 1) {
                this.curr[i][j] = this.next[i][j];
                this.next[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    public void generate() {
        int i = 1;
        while (i < this.w - 1) {
            int j = 1;
            while (j < this.h - 1) {
                int n = 0;
                int x = -1;
                while (x < 2 && n < 5) {
                    int y = -1;
                    while (y < 2 && n < 5) {
                        n += this.curr[i + x][j + y] ? 1 : 0;
                        ++y;
                    }
                    ++x;
                }
                this.next[i][j] = this.curr[i][j] ? n == 3 || n == 4 : n == 3;
                ++j;
            }
            ++i;
        }
    }

    public void periodicBoundary() {
        int i = 1;
        while (i < this.w - 1) {
            this.curr[i][0] = this.curr[i][this.h - 2];
            this.curr[i][this.h - 1] = this.curr[i][1];
            ++i;
        }
        int j = 1;
        while (j < this.h - 1) {
            this.curr[0][j] = this.curr[this.w - 2][j];
            this.curr[this.w - 1][j] = this.curr[1][j];
            ++j;
        }
        boolean s = this.curr[1][1];
        this.curr[0][0] = this.curr[this.w - 2][this.h - 2];
        this.curr[this.w - 1][this.h - 1] = s;
        s = this.curr[this.w - 2][1];
        this.curr[this.w - 1][0] = this.curr[1][this.h - 2];
        this.curr[0][this.h - 1] = s;
    }

    public void rand() {
        this.time = 0;
        int i = 1;
        while (i < this.w) {
            int j = 1;
            while (j < this.h) {
                this.curr[i][j] = game_of_life.round((float)this.random(1.0f)) == 1;
                this.next[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    public void render() {
        this.loadPixels();
        int i = 0;
        while (i < this.width) {
            int j = 0;
            while (j < this.height) {
                this.pixels[i + j * this.width] = this.curr[game_of_life.ceil((float)(i / this.g)) + 1][game_of_life.ceil((float)(j / this.g)) + 1] ? this.color(this.c, 100.0f, 100.0f) : this.color(0);
                ++j;
            }
            ++i;
        }
        this.updatePixels();
        this.c += this.c > 100.0f ? -this.c : 0.05f;
    }

    public void time() {
        ++this.time;
        if (this.time > 4096) {
            this.rand();
        }
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "game_of_life"};
        if (passedArgs != null) {
            PApplet.main((String[])game_of_life.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

